<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
// namespace UiGigs\Staco_Core;
use UiGigs\staco\Helper;  ?>

<div class="powerful-email-wrapper">
    <div class="powerful-email-content">
        <div class="row">
            <div class="col-md-6">
                <div class="powerful-email-left">
                    <div class="email-collaps-list">
                        <div class="timeline-innerline">
                            <div class="timeline-progress"></div>
                        </div>

                        <?php 
                        $i=0;
                        foreach ( $data['price_list'] as $items => $item ) {       
                            $i++;                    
                            $image_icon     = !empty($item['image_icon']) ? $item['image_icon'] : '';  
                            $step_title     = !empty($item['step_title']) ? $item['step_title'] : '';
                            $serial_number     = !empty($item['serial_number']) ? $item['serial_number'] : '';                            
                            $features       = !empty($item['features']) ? $item['features'] : ''; 
                            $activeClass = $i==1 ? ' active':'';   
                        ?>
                        <div class="email-collaps-item email-collaps-item<?php echo $i; ?>">
                            <div class="email-collaps-number">
                                 <?php echo wp_kses_post ($serial_number);?>
                            </div>
                            <div class="email-collaps-text">
                                <h3><?php echo wp_kses_post ($step_title);?></h3>
                                <p><?php echo wp_kses_post ($features);?></p>
                                <div class="powerful-email-img-mobile">
                                   <?php echo wp_get_attachment_image( $item['image_icon']['id'], 'full', '', ["class" => 'top-image'] ); ?>
                                </div>
                            </div>
                        </div>
                        <?php } ?>

                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="powerful-email-right">
                    <div class="powerful-email-img">
                        <?php 
                        $i=0;
                        foreach ( $data['price_list'] as $items => $item ) { 
                            $i++;  
                            $image_icon     = !empty($item['image_icon']) ? $item['image_icon'] : '';    
                            $activeClass = $i==1 ? ' active':'';   
                        ?> 
                        <?php echo wp_get_attachment_image( $item['image_icon']['id'], 'full', '', ["class" => 'email-collaps-img'.$i.''.$activeClass.''] ); ?>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>




<script>
    (function ($) {
    ("use strict");

        $(document).ready(function () {

        /*-- timeline start --*/
            var powerfullEmailContentwrapper = $(".powerful-email-wrapper");
            if (powerfullEmailContentwrapper.length) {
                $(window).on("scroll", function () {
                    fnOnScroll();
                });
                $(window).on("resize", function () {
                    fnOnResize();
                });
                var timelineListArea = $(".email-collaps-list"),
                    timelineInnerline = $(".timeline-innerline"),
                    timelineProgress = $(".timeline-progress"),
                    listItem = $(".email-collaps-item"),
                    agOuterHeight = $(window).outerHeight(),
                    agHeight = $(window).height(),
                    f = -1,
                    agFlag = false;

                function fnOnScroll() {
                    agPosY = $(window).scrollTop();

                    fnUpdateFrame();
                }
                function fnOnResize() {
                    agPosY = $(window).scrollTop();
                    agHeight = $(window).height();

                    fnUpdateFrame();
                }
                function fnUpdateWindow() {
                    agFlag = false;

                    f !== agPosY && ((f = agPosY), agHeight, fnUpdateProgress());
                }
                function fnUpdateProgress() {
                    var agTop = listItem.last().offset().top;

                    i = agTop + agPosY - $(window).scrollTop();

                    a = timelineProgress.offset().top + agPosY - $(window).scrollTop();

                    n = agPosY - a + agOuterHeight / 2;
                    i <= agPosY + agOuterHeight / 2 && (n = i - a);
                    timelineProgress.css({ height: n + "px" });

                    listItem.each(function () {
                        var agTop = $(this).offset().top;

                        agTop + agPosY - $(window).scrollTop() < agPosY + 0.5 * agOuterHeight
                            ? $(this).addClass("active").siblings().removeClass("active")
                            : $(this).removeClass("active");
                    });
                }

                function fnUpdateFrame() {
                    agFlag || requestAnimationFrame(fnUpdateWindow);
                    agFlag = true;
                }
            }

            var powerfulEmailactive = $(".powerful-email-content");
            if (powerfulEmailactive.length) {
                let totalItems, i;
                totalItems = powerfulEmailactive.find(".email-collaps-item");
                $(window).on("scroll", function () {
                    for (i = 1; i < totalItems.length; i++) {
                        if ($(`.email-collaps-item${i}`).hasClass("active")) {
                            $(`.email-collaps-img${i}`).addClass("active").siblings().removeClass("active");
                        }
                    }
                });
            }
            /*-- timeline end --*/

        });

    })(jQuery);

</script>



 

