<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

use Elementor\Icons_Manager; ?>

<div class="powerfull-template-content">
    <div class="timeline-innerline">
        <div class="timeline-progress"></div>
    </div>

        <?php 
            $i=0;
            foreach ( $data['step_list'] as $item ){  
        ?>   
        <?php if($i%2 == 0 ){ ?>
            <div class="powerfull-template-row">
                <div class="powerfull-template-number"><?php echo wp_kses_post($item['number']) ?></div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="powerfull-template-img powerfull-template-img-left">
                            <?php echo wp_get_attachment_image( $item['image_icon']['id'], 'full' ); ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="powerfull-template-text powerfull-template-text-right">
                            <h4><?php echo wp_kses_post($item['title']) ?></h4>
                            <?php echo wp_kses_post($item['desc']) ?>
                    
                            <?php if(!empty($item['list1'] || $item['list2'] || $item['list3'])){ ?>
                            <ol>
                                <?php if (!empty($item['list1'])) { ?>
                                <li>
                                    <?php if (!empty($item['list1'])) { ?>
                                    <span>
                                        <?php \Elementor\Icons_Manager::render_icon( $item['icon1'], [ 'aria-hidden' => 'true' ] ); ?></i>	
                                    </span>
                                    <?php } ?> 
                                    <?php echo wp_kses_post($item['list1']) ?>
                                </li>
                                <?php } ?>

                                <?php if (!empty($item['list2'])) { ?>
                                <li>
                                    <?php if (!empty($item['list2'])) { ?>
                                    <span>
                                        <?php \Elementor\Icons_Manager::render_icon( $item['icon2'], [ 'aria-hidden' => 'true' ] ); ?></i>	
                                    </span>
                                    <?php } ?> 
                                    <?php echo wp_kses_post($item['list2']) ?>
                                </li>
                                <?php } ?> 

                                <?php if (!empty($item['list3'])) { ?>
                                <li>
                                    <?php if (!empty($item['list3'])) { ?>
                                    <span>
                                        <?php \Elementor\Icons_Manager::render_icon( $item['icon3'], [ 'aria-hidden' => 'true' ] ); ?></i>	
                                    </span>
                                    <?php } ?> 
                                    <?php echo wp_kses_post($item['list3']) ?>
                                </li>
                                <?php } ?> 
                            </ol>
                            <?php } ?> 

                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if($i%2 == 1 ){ ?>
            <div class="powerfull-template-row">
                <div class="powerfull-template-number"><?php echo wp_kses_post($item['number']) ?></div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="powerfull-template-text powerfull-template-text-left">
                            <h4><?php echo wp_kses_post($item['title']) ?></h4>
                            <?php echo wp_kses_post($item['desc']) ?>
                            <?php if(!empty($item['list1'] || $item['list2'] || $item['list3'])){ ?>
                            <ol>
                                <?php if (!empty($item['list1'])) { ?>
                                <li>
                                    <?php if (!empty($item['list1'])) { ?>
                                    <span>
                                        <?php \Elementor\Icons_Manager::render_icon( $item['icon1'], [ 'aria-hidden' => 'true' ] ); ?></i>	
                                    </span>
                                    <?php } ?> 
                                    <?php echo wp_kses_post($item['list1']) ?>
                                </li>
                                <?php } ?>

                                <?php if (!empty($item['list2'])) { ?>
                                <li>
                                    <?php if (!empty($item['list2'])) { ?>
                                    <span>
                                        <?php \Elementor\Icons_Manager::render_icon( $item['icon2'], [ 'aria-hidden' => 'true' ] ); ?></i>	
                                    </span>
                                    <?php } ?> 
                                    <?php echo wp_kses_post($item['list2']) ?>
                                </li>
                                <?php } ?> 

                                <?php if (!empty($item['list3'])) { ?>
                                <li>
                                    <?php if (!empty($item['list3'])) { ?>
                                    <span>
                                        <?php \Elementor\Icons_Manager::render_icon( $item['icon3'], [ 'aria-hidden' => 'true' ] ); ?></i>	
                                    </span>
                                    <?php } ?> 
                                    <?php echo wp_kses_post($item['list3']) ?>
                                </li>
                                <?php } ?> 
                            </ol>
                            <?php } ?> 
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="powerfull-template-img powerfull-template-img-right">
                            <?php echo wp_get_attachment_image( $item['image_icon']['id'], 'full' ); ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
        <div class="powerfull-template-row"></div>

        <?php $i++; } ?>
</div>
<script>
    (function ($) {
    ("use strict");
        $(document).ready(function () {

/*-- timeline start --*/
    var powerfullTemplateContent = $(".powerfull-template-content");
    if (powerfullTemplateContent.length) {
        $(window).on("scroll", function () {
            fnOnScroll();
        });

        $(window).on("resize", function () {
            fnOnResize();
        });

        var timelineListArea = $(".powerfull-template-content"),
            timelineInnerline = $(".timeline-innerline"),
            timelineProgress = $(".timeline-progress"),
            listItem = $(".powerfull-template-row"),
            agOuterHeight = $(window).outerHeight(),
            agHeight = $(window).height(),
            f = -1,
            agFlag = false;

        function fnOnScroll() {
            agPosY = $(window).scrollTop();

            fnUpdateFrame();
        }

        function fnOnResize() {
            agPosY = $(window).scrollTop();
            agHeight = $(window).height();

            fnUpdateFrame();
        }

        function fnUpdateWindow() {
            agFlag = false;

            f !== agPosY && ((f = agPosY), agHeight, fnUpdateProgress());
        }

        function fnUpdateProgress() {
            var agTop = listItem.last().offset().top;

            i = agTop + agPosY - $(window).scrollTop();

            a = timelineProgress.offset().top + agPosY - $(window).scrollTop();

            n = agPosY - a + agOuterHeight / 2;
            i <= agPosY + agOuterHeight / 2 && (n = i - a);
            timelineProgress.css({ height: n + "px" });

            listItem.each(function () {
                var agTop = $(this).offset().top;

                agTop + agPosY - $(window).scrollTop() < agPosY + 0.5 * agOuterHeight
                    ? $(this).addClass("active")
                    : $(this).removeClass("active");
            });
        }

        function fnUpdateFrame() {
            agFlag || requestAnimationFrame(fnUpdateWindow);
            agFlag = true;
        }
    }
    /*-- timeline end --*/

  });
    })(jQuery);
</script>



