<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

use Elementor\Icons_Manager; ?>

<div class="app-benefits-card">
    <?php if (!empty($data['sevice_image_icon']['url'])) : ?>
    <div class="app-benefits-card-img account">
        <img src="<?php echo esc_url($data['sevice_image_icon']['url']); ?>" alt="image" />
    </div>
    <?php endif; ?>
    <div class="app-benefits-card-text">
        <h5 class="wt-700"><?php echo wp_kses_post($data['title']); ?></h5>
        <p><?php echo wp_kses_post($data['text']); ?></p>
    </div>
</div>
<script>
    (function ($) {
    ("use strict");
        $(document).ready(function () {
            var benefitsCardImg = $(".app-benefits-card-img");
            if (benefitsCardImg.length) {
                $(window).on("scroll", function () {
                    var CardImage = $(".app-benefits-card-img img");
                    var y = window.scrollY;
                    var x;
                    x = CardImage.offset().top;
                    x = x - 400;

                    let animationValue = 0;
                    animationValue = (y - x) / 2;

                    let animationStop = 100;

                    if (animationValue < 0) {
                        animationValue = 0;
                    }

                    if (animationValue > animationStop) {
                        animationValue = animationStop;
                    }

                    CardImage.css("transform", `translateY(${animationValue}px)`);
                });
            }
     });
    })(jQuery);
</script>




