<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class shareBox extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Social Share Box', 'staco-core' );
		$this->rt_base = 'share-box-area';
		parent::__construct( $data, $args );
	}
	
	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__('Social Share Box', 'staco-core'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'image_icon',
			[
				'label' => esc_html__('Icon Image', 'scaddon'),
				'type' => Controls_Manager::MEDIA,
				'separator' => 'before',
			]
		);
	
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'description' => __( 'Title Here', 'staco-core' ),
			]
		);
		$this->add_control(
			'desc',
			[
				'label'       => __( 'Description', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'description' => __( 'Description', 'staco-core' ),
			]
		);
		$this->add_control(
			'link',
			[
				'label'       => __( 'Link', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'description' => __( 'Link Here', 'staco-core' ),
			]
		);
		$this->end_controls_section();
		/* = Description Settings
		==============================================================*/
		$this->start_controls_section(
			'description_settings',
			[
				'label' => esc_html__( 'Style Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Title Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .defi-get-update-card h5' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typo',
				'label'    => esc_html__( 'Title Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .defi-get-update-card h5',
			]
		);
		$this->add_control(
			'des_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Description Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .defi-get-update-card p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'des_typo',
				'label'    => esc_html__( 'Description Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .defi-get-update-card p',
			]
		);

		$this->end_controls_section();
    }

	protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		$this->rt_template( $template, $data );
	}

}