<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

use Elementor\Icons_Manager; ?>
<div class="portfolio-gallery-content">
    <div class="portfolio-grid-container row staco-masonry-grid" data-masonry='{"percentPosition": true }'>
 <?php $i = 1;
        foreach ( $data['port_list'] as $portfolio ) {
    ?>
        <div class="col-md-4 col-sm-6 staco-grid-item">
            <div class="portfolio-gallery-card  portfolio-gallery-card<?php echo $i; ?>">
                <div
                    class="parallax-window"
                    data-parallax="scroll"
                    data-image-src="<?php echo esc_url($portfolio['image']['url']); ?>"
                >
                    <a href="<?php echo esc_url($portfolio['image']['url']); ?>"
                        class="portfolio-img"
                        data-lightbox="roadtrip"
                        ><img src="<?php echo esc_url($portfolio['image']['url']); ?>" alt="img"
                    />
                    </a>
                    <div class="portfolio-details">
                        <div class="portfolio-text-card">
                            <div class="portfolio-text">
                                <h5><a href="<?php echo wp_kses_post($portfolio['title_link']);?>"><?php echo wp_kses_post($portfolio['title']);?></a></h5>
                                <h6><?php echo wp_kses_post($portfolio['category']);?></h6>
                            </div>
                            <a href="<?php echo wp_kses_post($portfolio['title_link']);?>" class="portfolio-text-link">
                                <div class="icon">
                                    <span
                                        class="iconify"
                                        data-icon="akar-icons:chevron-right"
                                    ></span>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php $i++; } ?>
    </div>
</div>

