<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;
use Elementor\Repeater;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class stacoProducts extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Staco Products Slider', 'staco-core' );
		$this->rt_base = 'stacoProducts';
		parent::__construct( $data, $args );
	}

	protected function register_controls() {
		$this->start_controls_section(
            'step_section',
            [
                'label' => esc_html__( 'Staco Products Slider', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
		$this->add_control(
            'staco_product_product_filter',
            [
                'label' => esc_html__('Filter By', 'rtelements'),
                'type' => Controls_Manager::SELECT,
                'default' => 'recent-products',
                'options' => [
					'recent-products'       => esc_html__('Recent Products', 'rtelements'),
					'featured-products'     => esc_html__('Featured Products', 'rtelements'),
					'best-selling-products' => esc_html__('Best Selling Products', 'rtelements'),
					'sale-products'         => esc_html__('Sale Products', 'rtelements'),
					'top-products'          => esc_html__('Top Rated Products', 'rtelements'),
                ],
            ]
        );
		$this->add_control(
            'staco_product_products_count',
            [
				'label'   => __('Products Count', 'rtelements'),
				'type'    => Controls_Manager::NUMBER,
				'default' => 4,
				'min'     => 1,
				'max'     => 1000,
				'step'    => 1,
            ]
        );
		$this->add_control(
            'staco_product_categories',
            [
				'label'       => esc_html__('Product Categories', 'rtelements'),
				'type'        => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple'    => true,
				'options'     =>stacoelemetns_woocommerce_product_categories(),
            ]
        );
        $this->end_controls_section();

    }

	protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		$this->rt_template( $template, $data );
	}

}