<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
// namespace UiGigs\Staco_Core;
use UiGigs\staco\Helper;  ?>

 <div class="crypto-hero-img">
    <div class="mobile-img">
        <div class="mobile-slider">
            <?php foreach ( $data['price_list'] as $items => $item ) {                           
                $image_icon     = !empty($item['image_icon']) ? $item['image_icon'] : '';                           
            ?>
            <div><?php echo wp_get_attachment_image( $item['image_icon']['id'], 'full' ); ?></div>
            <?php } ?> 
        </div>
    </div>
</div>

<script>
    (function ($) {
    ("use strict");
        $(document).ready(function () {
            var mobileSlider = $(".mobile-slider");
                if (mobileSlider.length) {
                    $(".mobile-slider").slick({
                        slidesToShow: 1,
                        slidesToScroll: 1,
                        arrows: false,
                        fade: true,
                        autoplay: true,
                        autoplaySpeed: 3000,
                        infinite: true,
                        pauseOnHover: false,
                        pauseOnFocus: false,
                        dots: false,
                    });
                }
            });

            var bannerMobileImg = $(".mobile-img");
            if (bannerMobileImg.length) {
                $(window).on("scroll", function () {
                    var cryptoBannerImg = $(".mobile-img");
                    var y = window.scrollY;
                    var x;
                    x = cryptoBannerImg.offset().top;
                    x = x - 400;

                    let animationValue = 1;
                    animationValue = (y - x) / 4;

                    let animationStop = 100;

                    if (animationValue < 0) {
                        animationValue = 0;
                    }

                    if (animationValue > animationStop) {
                        animationValue = animationStop;
                    }

                    cryptoBannerImg.css("transform", `translateY(${animationValue}px)`);
                });
            }
    })(jQuery);
</script>


 

