<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

use Elementor\Icons_Manager;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class stacoTestimonial extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Staco Testimonial', 'staco-core' );
		$this->rt_base = 'staco-testimonial';
		parent::__construct( $data, $args );
	}

	protected function register_controls() {
		/* = Faq Options
		============================================*/
		$this->start_controls_section(
			'faq_list_section',
			[
				'label' => __( 'Testimonial List', 'staco-core' ),
			]
		);
		 $this->add_control(
			'layout',
			[
				'label' => __('Layout Type', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' => __( 'Style 1', 'staco-core' ),
					'style2' => __( 'Style 2', 'staco-core' ),
					'style3' => __( 'Style 3', 'staco-core' ),
					'style4' => __( 'Style 4', 'staco-core' ),
					'style5' => __( 'Style 5', 'staco-core' ),
					'style6' => __( 'Style 6', 'staco-core' ),
					'style7' => __( 'Style 7', 'staco-core' ),
				],
				'label_block' => true,
			]
		);
		$this->add_control(
			'subtitle', [
				'label' => __( 'Subtitle', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Testimonials' , 'staco-core' ),
				'condition'      => ['layout' => ['style1']],
			]
		);
		$this->add_control(
			'maintitle', [
				'label' => __( 'Title', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'We Feedback' , 'staco-core' ),
				'condition'      => ['layout' => ['style1']],
			]
		);

		

		$this->add_control(
			'image_bg',
			[
				'label'   => __( 'Backgroud Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition'      => ['layout!' => ['style1']],
			]
		);
		$this->add_control(
			'icon_image',
			[
				'label'   => __( 'Icon Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition'      => ['layout!' => ['style1']],
			]
		);

		$this->add_control(
			'author_icon',
			[
				'label' => __('Author Icon Top/Buttom', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'buttom',
				'options' => [
					'top' => __( 'Top', 'staco-core' ),
					'buttom' => __( 'Buttom', 'staco-core' ),
				],
				'label_block' => true,
				'condition'      => ['layout' => ['style5']],
			]
		);
		$this->add_control(
			'quote-icon',
			[
				'label' => __('Quote Icon On/Off', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'icon_on',
				'options' => [
					'icon_on' => __( 'On', 'staco-core' ),
					'icon_off' => __( 'Off', 'staco-core' ),
				],
				'label_block' => true,
				'condition'      => ['layout' => ['style5']],
			]
		);
		$this->add_control(
			'navigation_arrow',
			[
				'label' => __('Arrow True/False', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'false',
				'options' => [
					'true' => __( 'True', 'staco-core' ),
					'false' => __( 'False', 'staco-core' ),
				],
				'label_block' => true,
				'condition'      => ['layout' => ['style5']],
			]
		);

		$this->add_control(
			'navigation_dots',
			[
				'label' => __('Dots True/False', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'true',
				'options' => [
					'true' => __( 'True', 'staco-core' ),
					'false' => __( 'False', 'staco-core' ),
				],
				'label_block' => true,
				'condition'      => ['layout' => ['style5']],
			]
		);

		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'title', [
				'label' => __( 'Title', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'digination', [
				'label' => __( 'Digination', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'desc_text', [
				'label' => __( 'Content', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => __( 'List Content' , 'staco-core' ),
				'show_label' => false,
			]
		);
		$repeater->add_control(
			'image',
			[
				'label'   => __( 'Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'rating', [
				'label' => __( 'Rating', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'faq_list',
			[
				'label'       => __( 'Testimonial Items', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'title'    => 'Smith, Jhon',
						'digination'    => 'Director, Growth King',
						'desc_text' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. ',
					],
					[
						'title'    => 'Roe Smith,',
						'digination'    => 'Director, Growth King',
						'desc_text' => 'I must explain to you how all this mistaken. Tdea of denouncing pleasure and
                      praising pain was born and I will give you acomplete account. Create automation
                      scenarios with on your own servers. 😍',
					],
				],
				'title_field' => '{{{ title }}}',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'client_logo2',
			[
				'label' => __( 'List Two', 'staco-core' ),
				'condition'      => ['layout' => ['style7']],
			]
		);

		

		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'title2', [
				'label' => __( 'Title', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'digination2', [
				'label' => __( 'Digination', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'desc_text2', [
				'label' => __( 'Content', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => __( 'List Content' , 'staco-core' ),
				'show_label' => false,
			]
		);
		$repeater->add_control(
			'image2',
			[
				'label'   => __( 'Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'faq_list2',
			[
				'label'       => __( 'Testimonial Items', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'title2'    => 'Smith, Jhon',
						'digination'    => 'Director, Growth King',
						'desc_text' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. ',
					],
					[
						'title2'    => 'Roe Smith,',
						'digination'    => 'Director, Growth King',
						'desc_text' => 'I must explain to you how all this mistaken. Tdea of denouncing pleasure and
                      praising pain was born and I will give you acomplete account. Create automation
                      scenarios with on your own servers. 😍',
					],
				],
				'title_field' => '{{{ title2 }}}',
			]
		);
		
		$this->end_controls_section();

		$this->start_controls_section(
			'client_logo3',
			[
				'label' => __( 'List Three', 'staco-core' ),
				'condition'      => ['layout' => ['style7']],
			]
		);

		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'title3', [
				'label' => __( 'Title', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'digination3', [
				'label' => __( 'Digination', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'desc_text3', [
				'label' => __( 'Content', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => __( 'List Content' , 'staco-core' ),
				'show_label' => false,
			]
		);
		$repeater->add_control(
			'image3',
			[
				'label'   => __( 'Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'faq_list3',
			[
				'label'       => __( 'Testimonial Items', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'title3'    => 'Smith, Jhon',
						'digination'    => 'Director, Growth King',
						'desc_text' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. ',
					],
					[
						'title3'    => 'Roe Smith,',
						'digination'    => 'Director, Growth King',
						'desc_text' => 'I must explain to you how all this mistaken. Tdea of denouncing pleasure and
                      praising pain was born and I will give you acomplete account. Create automation
                      scenarios with on your own servers. 😍',
					],
				],
				'title_field' => '{{{ title3 }}}',
			]
		);
		$this->end_controls_section();


		/* = Faq Options
		============================================*/
		$this->start_controls_section(
			'client_logo',
			[
				'label' => __( 'Logo List', 'staco-core' ),
				'condition'      => ['layout!' => ['style1', 'style7']],
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'client_tite', [
				'label' => __( 'Title', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'client_image',
			[
				'label'   => __( 'Logo Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'logo_list',
			[
				'label'       => __( 'Logo List', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'client_tite'    => 'Logo 1',
					],
				],
				'title_field' => '{{{ client_tite }}}',
			]
		);
		$this->end_controls_section();


        /* = Global Settings
		==============================================================*/
		$this->start_controls_section(
			'global_settings',
			[
				'label' => esc_html__( 'Global Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'left_heading',
			[
				'type' => Controls_Manager::HEADING,
				'label' => esc_html__('Left Background', 'scaddon'),
				'separator' => 'before'
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'left_bg',
				'label' => esc_html__('Background Color', 'scaddon'),
				'types' => ['classic', 'gradient'],
				'selector' => '{{WRAPPER}} .testimonial-card-left',
				'condition'      => ['layout' => ['style1']],
			]
		);
		$this->add_responsive_control(
			'right_content_padding',
			[
				'label' => esc_html__('Content Padding', 'scaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .testimonial-card-right' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'      => ['layout' => ['style1']],
			]
		);
		$this->add_control(
			'right_heading',
			[
				'type' => Controls_Manager::HEADING,
				'label' => esc_html__('Right Background', 'scaddon'),
				'separator' => 'before'
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'right_bg',
				'label' => esc_html__('Background Color', 'scaddon'),
				'types' => ['classic', 'gradient'],
				'selector' => '{{WRAPPER}} .testimonial-card-right',
				'condition'      => ['layout' => ['style1']],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'item_bg_color',
				'label' => esc_html__('Background Color', 'scaddon'),
				'types' => ['classic', 'gradient'],
				'selector' => '{{WRAPPER}} .testimonial-card'
			]
		);
		$this->add_responsive_control(
			'item_border_radius',
			[
				'label' => esc_html__('Border Radius', 'scaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .testimonial-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_control(
			'image_background',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Image Background', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .author_center_image img' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
            'img_width',
            [
                'label' => esc_html__('Image Width', 'staco'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 2000,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .author_center_image img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
		$this->add_responsive_control(
            'img_height',
            [
                'label' => esc_html__('Image Height', 'staco'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 2000,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .author_center_image img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
		$this->add_responsive_control(
			'img_border_radius',
			[
				'label' => esc_html__('Image Border Radius', 'scaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .author_center_image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_responsive_control(
			'align',
			[
				'label' => esc_html__('Alignment', 'scaddon'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__('Left', 'scaddon'),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__('Center', 'scaddon'),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__('Right', 'scaddon'),
						'icon' => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__('Justify', 'scaddon'),
						'icon' => 'fa fa-align-justify',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .clint-img, {{WRAPPER}} .testimonial-card' => 'text-align: {{VALUE}}'
				],
				'separator' => 'before',
			]
		);
		$this->end_controls_section();

		/* = Title Settings
		==============================================================*/
		$this->start_controls_section(
			'title_settings',
			[
				'label' => esc_html__( 'Title Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Title Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .chatbot-testmonial-content .clint-content .clint-info span, {{WRAPPER}} .faq-box .panel-heading .accordion-button' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typo',
				'label'    => esc_html__( 'Title Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .chatbot-testmonial-content .clint-content .clint-info span, {{WRAPPER}} .faq-box .panel-heading .accordion-button',
			]
		);
		$this->add_control(
			'digination_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Digination Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .clint-content .clint-info p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'digination_typo',
				'label'    => esc_html__( 'Title Typography', 'staco-core' ),
				'selector' => '.clint-content .clint-info p',
			]
		);
		$this->end_controls_section();

		/* = Text Settings
		==============================================================*/
		$this->start_controls_section(
			'text_settings',
			[
				'label' => esc_html__( 'Text Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'text_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}}  .chatbot-testmonial-content .testmonial-quote-text, {{WRAPPER}} .faq-box .panel-body' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'text_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}}  .chatbot-testmonial-content .testmonial-quote-text, {{WRAPPER}}  .faq-box .panel-body',
			]
		);
		$this->add_responsive_control(
			'text_content_margin',
			[
				'label' => esc_html__('Content Margin', 'scaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .testmonial-quote-text, {{WRAPPER}} .happy-customer-slider-nav' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'      => ['layout' => ['style3', 'style5']],
			]
		);
		$this->end_controls_section();
    }

	protected function render() {
		$data = $this->get_settings();

		$template = 'view';
		if ( 'style2' == $data['layout'] ) {
			$template = 'view-2';
		}
		if ( 'style3' == $data['layout'] ) {
			$template = 'view-3';
		}
		if ( 'style4' == $data['layout'] ) {
			$template = 'view-4';
		}
		if ( 'style5' == $data['layout'] ) {
			$template = 'view-5';
		}
		if ( 'style6' == $data['layout'] ) {
			$template = 'view-6';
		}
		if ( 'style7' == $data['layout'] ) {
			$template = 'view-7';
		}
		$this->rt_template( $template, $data );
	}

}