<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

?>
<div class="staco-testimonial-area">
    <div class="row">
        <div class="col-lg-7">
            <div class="happy-customer-left">
                <div class="happy-customer-slider-for">
                    <?php 
                        foreach ( $data['faq_list'] as $testimonial ) {
                    ?>
                    <div class="slider-item">
                        <p>
                            <?php echo wp_kses_post( $testimonial['desc_text'] ) ?>
                        </p>
                        <div class="customers-name">
                            <h5><?php echo wp_kses_post( $testimonial['title'] ); ?></h5>
                            <div class="designation"><?php echo wp_kses_post( $testimonial['digination'] ); ?></div>
                        </div>
                    </div>
                    <?php } ?>
                </div>
            </div>
        </div>
        <div class="col-lg-5">
            <div class="happy-customer-right">
                <div class="bg-img">
                    <?php echo wp_get_attachment_image( $data['image_bg']['id'], 'full', '', ["class" => 'cat_foot_print'] ); ?>
                </div>
                <div class="happy-customer-slider-nav">
                    <?php 
                        foreach ( $data['faq_list'] as $testimonial ) {
                    ?>            
                    <div class="slider-item">
                        <div class="slider-img">
                            <div class="circle-progress">
                                <div class="halfclip">
                                    <div class="halfcircle clipped"></div>
                                </div>
                                <div class="halfcircle fixed"></div>
                            </div>
                            <?php echo wp_get_attachment_image( $testimonial['image']['id'], 'full' ); ?>
                        </div>
                    </div>
                    <?php } ?>
                    
                </div>
            </div>
        </div>
    </div>
</div>


<script>
    (function ($) {
        ("use strict");
        $(document).ready(function () {
            /*-- happy customer slider start --*/
            var happyCustomerSliderFor = $(".happy-customer-slider-for");
            if (happyCustomerSliderFor.length) {
                $(".happy-customer-slider-for").slick({
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    arrows: true,
                    prevArrow: "<div class='slick-prev slick-arrow'>",
                    nextArrow: "<div class='slick-next slick-arrow'>",
                    asNavFor: ".happy-customer-slider-nav",
                    autoplay: true,
                    autoplaySpeed: 6000,
                    infinite: true,
                    pauseOnHover: false,
                    pauseOnFocus: false,
                });

                var sliderCounter = document.createElement("div");
                sliderCounter.classList.add("slider-counter");
                happyCustomerSliderFor.append(sliderCounter);
                sliderCounter.innerHTML = "1/4";

                var updateSliderCounter = function (slick, currentIndex) {
                    currentSlide = slick.slickCurrentSlide() + 1;
                    slidesCount = slick.slideCount;
                    sliderCounter.innerHTML = currentSlide + "/" + slidesCount;
                };

                happyCustomerSliderFor.on("init", function (event, slick) {
                    updateSliderCounter(slick);
                });

                happyCustomerSliderFor.on("afterChange", function (event, slick, currentSlide) {
                    updateSliderCounter(slick, currentSlide);
                });
            }

            var happyCustomerSliderNav = $(".happy-customer-slider-nav");
            if (happyCustomerSliderNav.length) {
                $(".happy-customer-slider-nav").slick({
                    slidesToShow: 4,
                    slidesToScroll: 1,
                    asNavFor: ".happy-customer-slider-for",
                    dots: false,
                    centerMode: true,
                    focusOnSelect: true,
                });
            }
        });
    })(jQuery);
/*-- happy customer slider end --*/
</script>
