<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

?>
<div class="chatbot-testmonial-content staco-testimonial-slider">
    <div class="row chatbot-testmonial-slider">
        <?php 
            foreach ( $data['faq_list'] as $testimonial ) {
        ?>
        <div class="col-md-12">

        
            <?php if ( 'icon_on' == $data['quote-icon'] ) { ?>    
            <div class="testmonial-quote-icon">
                <div class="circle-progress">
                    <div class="halfclip">
                        <div class="halfcircle clipped"></div>
                    </div>
                    <div class="halfcircle fixed"></div>
                </div>
                <?php echo wp_get_attachment_image( $data['icon_image']['id'], 'full' ); ?>
            </div>
            <?php } ?>

            <?php if ( 'top' == $data['author_icon'] ) { ?>    
                <?php if(!empty($testimonial['image']['id']) ) { ?>
                    <div class="clint-img author_center_image">
                    <?php echo wp_get_attachment_image( $testimonial['image']['id'], 'full' ); ?>
                    </div>
                <?php } ?>
            <?php } ?>

            <p class="testmonial-quote-text">
                <?php echo esc_html__( $testimonial['desc_text'] ) ?>
            </p>
            <div class="clint-content">

                
                <?php if ( 'buttom' == $data['author_icon'] ) { ?>    
                    <?php if(!empty($testimonial['image']['id']) ) { ?>
                        <div class="clint-img">
                        <?php echo wp_get_attachment_image( $testimonial['image']['id'], 'full' ); ?>
                        </div>
                    <?php } ?>
                <?php } ?>

                <div class="clint-info">
                    <span><?php echo wp_kses_post( $testimonial['title'] ); ?></span>
                    <p><?php echo wp_kses_post( $testimonial['digination'] ); ?></p>
                </div>
            </div>
        </div>
        <?php } ?>
    </div>
</div>

<script>
    (function ($) {
        ("use strict");
        $(document).ready(function () {

         var chatbotTestmonialContent = $(".chatbot-testmonial-slider");
            if (chatbotTestmonialContent.length) {
                $('.chatbot-testmonial-slider').slick({
                    dots: <?php echo wp_kses_post( $data['navigation_dots'] ); ?>,
                    arrows: <?php echo wp_kses_post( $data['navigation_arrow'] ); ?>,
                    infinite: true,
                    autoplay: true,
                    speed: 500,
                    slidesToShow: 1,
                    pauseOnHover: false,
                    pauseOnFocus: false,
                });
            }
        });
    })(jQuery);
</script>