<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
?>

<div class="testimonial-card">
    <div class="testimonial-card-left">
        <div class="testimonial-slider-nav">
            <?php 
                foreach ( $data['faq_list'] as $testimonial ) {
            ?>
            <div class="slider-item">
                <?php echo wp_get_attachment_image( $testimonial['image']['id'], 'full' ); ?>
            </div>
            <?php } ?>
        </div>
    </div>
    
    <div class="testimonial-card-right">
        <?php if ( $data['subtitle'] || $data['maintitle'] ) { ?>
        <div class="section-title">
           <?php if ( $data['subtitle'] ){ ?>
                <span class="sub-title"><?php echo wp_kses_post( $data['subtitle'] ); ?></span>
            <?php } ?>

            <?php if ( $data['maintitle'] ){ ?>
                <h2 class="title white-color"><?php echo wp_kses_post( $data['maintitle'] ); ?></h2>
            <?php } ?>

        </div>
        <?php } ?>

        <div class="testimonial-slider-for">
            <?php 
                foreach ( $data['faq_list'] as $testimonial ) {
            ?>
            <div class="slider-item">
                <div class="slider-item-text">
                <p>
                    <?php echo wp_kses_post( $testimonial['desc_text'] ) ?>
                </p>
                <div class="slider-item-user">
                    <div class="author-info">
                        <span class="name"><?php echo wp_kses_post( $testimonial['title'] ); ?></span> 
                        <span class="duration"><?php echo wp_kses_post( $testimonial['digination'] ); ?></span>
                    </div>
                </div>
                </div>
            </div>
            <?php } ?>
        </div>
    </div>
</div>


<script>
    (function ($) {
    ("use strict");
        $(document).ready(function () {

            /*-- Testimonial slider scripts start --*/
            var testimonialSliderNav = $(".testimonial-slider-nav");
            if (testimonialSliderNav.length) {
                $(".testimonial-slider-nav").slick({
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    asNavFor: ".testimonial-slider-for",
                    dots: false,
                    arrows: false,
                    centerMode: true,
                    focusOnSelect: true,
                });
            }

            var testimonialSliderFor = $(".testimonial-slider-for");
            if (testimonialSliderFor.length) {
                $(".testimonial-slider-for").slick({
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    arrows: false,
                    asNavFor: ".testimonial-slider-nav",
                    autoplay: true,
                    autoplaySpeed: 5000,
                    infinite: true,
                    pauseOnHover: false,
                    pauseOnFocus: false,
                });

                var sliderInfoContainer = document.createElement("div");
                sliderInfoContainer.classList.add("slider-info");
                sliderInfoContainer.innerHTML =
                    '<div class="slider-arrow left"><span class="iconify" data-icon="bi:arrow-left"></span></div><div class="slider-counter"><p></p></div><div class="slider-arrow right"><span class="iconify" data-icon="bi:arrow-right"></span></div>';
                testimonialSliderFor.append(sliderInfoContainer);

                var sliderCounter = sliderInfoContainer.querySelector(".slider-counter p");
                sliderCounter.innerHTML = "1/5";

                var updateSliderCounter = function (slick, currentIndex) {
                    currentSlide = slick.slickCurrentSlide() + 1;
                    slidesCount = slick.slideCount;
                    sliderCounter.innerHTML = currentSlide + "/" + slidesCount;
                };

                testimonialSliderFor.on("init", function (event, slick) {
                    updateSliderCounter(slick);
                });

                testimonialSliderFor.on("afterChange", function (event, slick, currentSlide) {
                    updateSliderCounter(slick, currentSlide);
                });

                var sliderArrowLeft = $(".slider-arrow.left");
                sliderArrowLeft.on("click", function () {
                    $(".testimonial-slider-for").slick("slickPrev");
                });
                var sliderArrowRight = $(".slider-arrow.right");
                sliderArrowRight.on("click", function () {
                    $(".testimonial-slider-for").slick("slickNext");
                });
            }
        });
    })(jQuery);
</script>
