<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;
use Elementor\Repeater;
use Elementor\Icons_Manager;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Background;


if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class tabTestimonils extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Staco Tab Testimonial', 'staco-core' );
		$this->rt_base = 'tab-Testimonils';
		parent::__construct( $data, $args );
	}

	protected function register_controls() {
		/* = Testimonial List One
		============================================*/
		$this->start_controls_section(
			'faq_list_section',
			[
				'label' => __( 'Testimonial List 1', 'staco-core' ),
			]
		);

		$this->add_control(
			'tab_image',
			[
				'label'   => __( 'Tab Icon', 'staco-core' ),
				'type'    => Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'tabtitle', [
				'label' => __( 'Tab Title', 'staco-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'author_icon',
			[
				'label'   => __( 'Autor Icon', 'staco-core' ),
				'type'    => Controls_Manager::MEDIA,
			]
		);
		$repeater->add_control(
			'author_name', [
				'label' => __( 'Autor Name', 'staco-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Leo Quode' , 'staco-core' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'digination', [
				'label' => __( 'Digination', 'staco-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'CEO. Expresso Ltd.' , 'staco-core' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'desc_text', [
				'label' => __( 'Content', 'staco-core' ),
				'type' => Controls_Manager::WYSIWYG,
				'default' => __( 'The best @staco is there anyone who loves or pursues or desires to obtain pain of itself, because it is pain but because' , 'staco-core' ),
				'show_label' => false,
			]
		);

		$repeater->add_control(
			'view_text', [
				'label' => __( 'View On', 'staco-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'View On' , 'staco-core' ),
				'show_label' => false,
			]
		);

		$repeater->add_control(
			'view_link', [
				'label' => __( 'View Link', 'staco-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '#' , 'staco-core' ),
				'show_label' => false,
			]
		);

		$repeater->add_control(
			'view_icon',
			[
				'label'   => __( 'View Icon', 'staco-core' ),
				'type'    => Controls_Manager::MEDIA,
			]
		);
		
		$this->add_control(
			'faq_list',
			[
				'label'       => __( 'Testimonial Items', 'staco-core' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'author_name'    => 'Smith, Jhon',
						'digination'    => 'Director, Growth King',
						'desc_text' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. ',
					],
					[
						'author_name'    => 'Roe Smith,',
						'digination'    => 'Director, Growth King',
						'desc_text' => 'I must explain to you how all this mistaken. Tdea of denouncing pleasure and
                      praising pain was born and I will give you acomplete account. Create automation
                      scenarios with on your own servers. 😍',
					],
				],
				'title_field' => '{{{ author_name }}}',
			]
		);
		$this->end_controls_section();


		/* = Testimonial List Two
		============================================*/
		$this->start_controls_section(
			'faq_list_section2',
			[
				'label' => __( 'Testimonial List 2', 'staco-core' ),
			]
		);

		$this->add_control(
			'tab_image2',
			[
				'label'   => __( 'Tab Icon', 'staco-core' ),
				'type'    => Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'tabtitle2', [
				'label' => __( 'Tab Title', 'staco-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'author_icon2',
			[
				'label'   => __( 'View Icon', 'staco-core' ),
				'type'    => Controls_Manager::MEDIA,
			]
		);
		$repeater->add_control(
			'author_name2', [
				'label' => __( 'Autor Name', 'staco-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Leo Quode' , 'staco-core' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'digination2', [
				'label' => __( 'Digination', 'staco-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'CEO. Expresso Ltd.' , 'staco-core' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'desc_text2', [
				'label' => __( 'Content', 'staco-core' ),
				'type' => Controls_Manager::WYSIWYG,
				'default' => __( 'The best @staco is there anyone who loves or pursues or desires to obtain pain of itself, because it is pain but because' , 'staco-core' ),
				'show_label' => false,
			]
		);

		$repeater->add_control(
			'view_text2', [
				'label' => __( 'View On', 'staco-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'View On' , 'staco-core' ),
				'show_label' => false,
			]
		);

		$repeater->add_control(
			'view_link2', [
				'label' => __( 'View Link', 'staco-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '#' , 'staco-core' ),
				'show_label' => false,
			]
		);

		$repeater->add_control(
			'view_icon2',
			[
				'label'   => __( 'View Icon', 'staco-core' ),
				'type'    => Controls_Manager::MEDIA,
			]
		);
		
		$this->add_control(
			'faq_list2',
			[
				'label'       => __( 'Testimonial Items', 'staco-core' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'author_name2'    => 'Smith, Jhon',
						'digination2'    => 'Director, Growth King',
						'desc_text2' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. ',
					],
					[
						'author_name2'    => 'Roe Smith,',
						'digination2'    => 'Director, Growth King',
						'desc_text2' => 'I must explain to you how all this mistaken. Tdea of denouncing pleasure and
                      praising pain was born and I will give you acomplete account. Create automation
                      scenarios with on your own servers. 😍',
					],
				],
				'title_field' => '{{{ author_name2 }}}',
			]
		);
		$this->end_controls_section();


		/* = Testimonial List Three
		============================================*/
		$this->start_controls_section(
			'faq_list_section3',
			[
				'label' => __( 'Testimonial List 3', 'staco-core' ),
			]
		);

		$this->add_control(
			'tab_image3',
			[
				'label'   => __( 'Tab Icon', 'staco-core' ),
				'type'    => Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'tabtitle3', [
				'label' => __( 'Tab Title', 'staco-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'author_icon3',
			[
				'label'   => __( 'View Icon', 'staco-core' ),
				'type'    => Controls_Manager::MEDIA,
			]
		);
		$repeater->add_control(
			'author_name3', [
				'label' => __( 'Autor Name', 'staco-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Leo Quode' , 'staco-core' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'digination3', [
				'label' => __( 'Digination', 'staco-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'CEO. Expresso Ltd.' , 'staco-core' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'desc_text3', [
				'label' => __( 'Content', 'staco-core' ),
				'type' => Controls_Manager::WYSIWYG,
				'default' => __( 'The best @staco is there anyone who loves or pursues or desires to obtain pain of itself, because it is pain but because' , 'staco-core' ),
				'show_label' => false,
			]
		);

		$repeater->add_control(
			'view_text3', [
				'label' => __( 'View On', 'staco-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'View On' , 'staco-core' ),
				'show_label' => false,
			]
		);

		$repeater->add_control(
			'view_link3', [
				'label' => __( 'View Link', 'staco-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '#' , 'staco-core' ),
				'show_label' => false,
			]
		);

		$repeater->add_control(
			'view_icon3',
			[
				'label'   => __( 'View Icon', 'staco-core' ),
				'type'    => Controls_Manager::MEDIA,
			]
		);
		
		$this->add_control(
			'faq_list3',
			[
				'label'       => __( 'Testimonial Items', 'staco-core' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'author_name2'    => 'Smith, Jhon',
						'digination2'    => 'Director, Growth King',
						'desc_text2' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. ',
					],
					[
						'author_name2'    => 'Roe Smith,',
						'digination2'    => 'Director, Growth King',
						'desc_text2' => 'I must explain to you how all this mistaken. Tdea of denouncing pleasure and
                      praising pain was born and I will give you acomplete account. Create automation
                      scenarios with on your own servers. 😍',
					],
				],
				'title_field' => '{{{ author_name3 }}}',
			]
		);
		$this->end_controls_section();

		/* = Testimonial List Four
		============================================*/
		$this->start_controls_section(
			'faq_list_section4',
			[
				'label' => __( 'Testimonial List 4', 'staco-core' ),
			]
		);

		$this->add_control(
			'tab_image4',
			[
				'label'   => __( 'Tab Icon', 'staco-core' ),
				'type'    => Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'tabtitle4', [
				'label' => __( 'Tab Title', 'staco-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'author_icon4',
			[
				'label'   => __( 'View Icon', 'staco-core' ),
				'type'    => Controls_Manager::MEDIA,
			]
		);
		$repeater->add_control(
			'author_name4', [
				'label' => __( 'Autor Name', 'staco-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Leo Quode' , 'staco-core' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'digination4', [
				'label' => __( 'Digination', 'staco-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'CEO. Expresso Ltd.' , 'staco-core' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'desc_text4', [
				'label' => __( 'Content', 'staco-core' ),
				'type' => Controls_Manager::WYSIWYG,
				'default' => __( 'The best @staco is there anyone who loves or pursues or desires to obtain pain of itself, because it is pain but because' , 'staco-core' ),
				'show_label' => false,
			]
		);

		$repeater->add_control(
			'view_text4', [
				'label' => __( 'View On', 'staco-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'View On' , 'staco-core' ),
				'show_label' => false,
			]
		);

		$repeater->add_control(
			'view_link4', [
				'label' => __( 'View Link', 'staco-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '#' , 'staco-core' ),
				'show_label' => false,
			]
		);

		$repeater->add_control(
			'view_icon4',
			[
				'label'   => __( 'View Icon', 'staco-core' ),
				'type'    => Controls_Manager::MEDIA,
			]
		);
		
		$this->add_control(
			'faq_list4',
			[
				'label'       => __( 'Testimonial Items', 'staco-core' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'author_name2'    => 'Smith, Jhon',
						'digination2'    => 'Director, Growth King',
						'desc_text2' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. ',
					],
					[
						'author_name2'    => 'Roe Smith,',
						'digination2'    => 'Director, Growth King',
						'desc_text2' => 'I must explain to you how all this mistaken. Tdea of denouncing pleasure and
                      praising pain was born and I will give you acomplete account. Create automation
                      scenarios with on your own servers. 😍',
					],
				],
				'title_field' => '{{{ author_name4 }}}',
			]
		);
		$this->end_controls_section();


		/* = Title Settings
		==============================================================*/
		$this->start_controls_section(
			'title_settings',
			[
				'label' => esc_html__( 'Title Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .faq-box .panel-heading .accordion-button' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .faq-box .panel-heading .accordion-button',
			]
		);
		$this->end_controls_section();

		/* = Text Settings
		==============================================================*/
		$this->start_controls_section(
			'text_settings',
			[
				'label' => esc_html__( 'Text Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'text_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .faq-box .panel-body' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'text_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}}  .faq-box .panel-body',
			]
		);
		$this->end_controls_section();
    }

	protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		$this->rt_template( $template, $data );
	}

}