<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

use UiGigs\staco\Helper;

if( ! class_exists('UiGigs\staco\Helper') )
	return;
?>

<div class="team-card <?php echo esc_attr( $data['layout'] ) ?>">
	<div class="team-card-img">
		<?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html( $data, 'thumbnail', 'image' ); ?>
	</div>
	<div class="team-card-info">
		<h5><?php echo esc_html( $data['name'] ) ?></h5>
		<p><?php echo esc_html( $data['designation'] ) ?></p>
	</div>
	<?php
	if ( ! empty( $data['social_icon_list'] ) ) {
		Helper::get_user_social_info( $data['social_icon_list'] );
	}
	?>
</div>