<?php
/**
 * @author  UIGIGS
 * @since   1.0
 * @version 1.1
 */

 namespace UiGigs\Staco_Core;

use \FW_Ext_Backups_Demo;

if ( ! defined( 'ABSPATH' ) ) exit;

class Demo_Importer {

	protected static $instance;

	public function __construct() {
		add_filter( 'plugin_action_links_rt-demo-importer/rt-demo-importer.php', array( $this, 'add_action_links' ) ); // Link from plugins page 
		add_filter( 'rt_demo_installer_warning', array( $this, 'data_loss_warning' ) );
		add_filter( 'fw:ext:backups-demo:demos', array( $this, 'demo_config' ) );
		add_action( 'fw:ext:backups:tasks:success:id:demo-content-install', array( $this, 'after_demo_install' ) );
	}

	public static function instance() {
		if ( null == self::$instance ) {
			self::$instance = new self;
		}
		return self::$instance;
	}

	public function add_action_links( $links ) {
		$mylinks = array(
			'<a href="' . esc_url( admin_url( 'tools.php?page=fw-backups-demo-content' ) ) . '">'.__( 'Install Demo Contents', 'staco-core' ).'</a>',
		);
		return array_merge( $links, $mylinks );
	}

	public function data_loss_warning( $links ) {
		$html  = '<div style="margin-top:20px;color:#f00;font-size:20px;line-height:1.3;font-weight:600;margin-bottom:40px;border-color: #f00;border-style: dashed;border-width: 1px 0;padding:10px 0;">';
		$html .= __( 'Warning: Your all old data will be lost if you install One Click demo data from here, so it is suitable only for a new website.', 'staco-core');
		$html .= '</div>';
		return $html;
	}

	public function demo_config( $demos ) {
		$demos_array = array(
			'demo1' => array(
				'title' => __( 'Home', 'staco-core' ),
				'screenshot' => plugins_url( 'screenshots/01.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://staco.uigaint.com/',
			),
			'demo2' => array(
				'title' => __( 'Customer Service', 'staco-core' ),
				'screenshot' => plugins_url( 'screenshots/02.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://staco.uigaint.com/customer-service/',
			),
			'demo3' => array(
				'title' => __( 'Team Collaboration', 'staco-core' ),
				'screenshot' => plugins_url( 'screenshots/03.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://staco.uigaint.com/team-collaboration/',
			),
			'demo4' => array(
				'title' => __( 'SaaS Landing One', 'staco-core' ),
				'screenshot' => plugins_url( 'screenshots/04.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://staco.uigaint.com/saas-landing-one/',
			),
			'demo5' => array(
				'title' => __( 'Home Sass Landing', 'staco-core' ),
				'screenshot' => plugins_url( 'screenshots/05.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://staco.uigaint.com/home-sass-landing/',
			),
			'demo6' => array(
				'title' => __( 'App Landing', 'staco-core' ),
				'screenshot' => plugins_url( 'screenshots/06.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://staco.uigaint.com/app-landing/',
			),
			'demo7' => array(
				'title' => __( 'Corporate Home', 'staco-core' ),
				'screenshot' => plugins_url( 'screenshots/07.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://staco.uigaint.com/corporate-home/',
			),
			'demo8' => array(
				'title' => __( 'Crypto Wallet', 'staco-core' ),
				'screenshot' => plugins_url( 'screenshots/08.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://staco.uigaint.com/crypto-wallet/',
			),
			'demo9' => array(
				'title' => __( 'Crypto Wallet 2', 'staco-core' ),
				'screenshot' => plugins_url( 'screenshots/09.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://staco.uigaint.com/crypto-wallet-2/',
			),
			'demo10' => array(
				'title' => __( 'Crypto Token', 'staco-core' ),
				'screenshot' => plugins_url( 'screenshots/10.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://staco.uigaint.com/crypto-token/',
			),
			'demo11' => array(
				'title' => __( 'Defi Web3', 'staco-core' ),
				'screenshot' => plugins_url( 'screenshots/11.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://staco.uigaint.com/defi-web3/',
			),
			'demo12' => array(
				'title' => __( 'Newsletter', 'staco-core' ),
				'screenshot' => plugins_url( 'screenshots/12.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://staco.uigaint.com/newsletter/',
			),
			'demo13' => array(
				'title' => __( 'Finance', 'staco-core' ),
				'screenshot' => plugins_url( 'screenshots/13.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://staco.uigaint.com/finance/',
			),
			'demo14' => array(
				'title' => __( 'Home Chatbot', 'staco-core' ),
				'screenshot' => plugins_url( 'screenshots/14.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://staco.uigaint.com/home-chatbot/',
			),
			'demo15' => array(
				'title' => __( 'Business', 'staco-core' ),
				'screenshot' => plugins_url( 'screenshots/15.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://staco.uigaint.com/business/',
			),
			'demo16' => array(
				'title' => __( 'Accounting', 'staco-core' ),
				'screenshot' => plugins_url( 'screenshots/16.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://staco.uigaint.com/accounting/',
			),
			'demo17' => array(
				'title' => __( 'Portfolio', 'staco-core' ),
				'screenshot' => plugins_url( 'screenshots/17.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://staco.uigaint.com/portfolio/',
			),
		);

		$download_url = 'https://staco.uigaint.com/wp-content/demo-content/';

		foreach ($demos_array as $id => $data) {
			$demo = new FW_Ext_Backups_Demo($id, 'piecemeal', array(
				'url' => $download_url,
				'file_id' => $id,
			));
			$demo->set_title($data['title']);
			$demo->set_screenshot($data['screenshot']);
			$demo->set_preview_link($data['preview_link']);

			$demos[ $demo->get_id() ] = $demo;

			unset($demo);
		}
		return $demos;
	}

	public function after_demo_install( $collection ){
		// Update front page id
		$demos = array(
			'demo1'  => 9,
			'demo2'  => 884,
			'demo3'  => 1226,
			'demo4'  => 2366,
			'demo5'  => 11223,
			'demo6'  => 7212,
			'demo7'  => 8880,
			'demo8'  => 8429,
			'demo9'  => 9430,
			'demo10' => 10296,
			'demo11' => 10716,
			'demo12' => 7556,
			'demo13' => 3383,
			'demo14' => 6374,
			'demo14' => 2007,
			'demo16' => 4989,
			'demo17' => 3792,
		);

		$data = $collection->to_array();

		foreach( $data['tasks'] as $task ) {
			if( $task['id'] == 'demo:demo-download' ){
				$demo_id = $task['args']['demo_id'];
				$page_id = $demos[$demo_id];
				update_option( 'page_on_front', $page_id );
				flush_rewrite_rules();
				break;
			}
		}

		// Update post author id
		global $wpdb;
		$id = get_current_user_id();
		$query = "UPDATE $wpdb->posts SET post_author = $id";
		$wpdb->query($query);
	}
}

Demo_Importer::instance();