<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace uigigs\Staco_Core;
use \staco_Posts;
use UiGigs\staco\staco;

if ( !class_exists( 'staco_Posts' ) ) {
	return;
}

$prefix = Staco_Core_THEME_PREFIX;

$post_types = array(
	"{$prefix}_event"  => array(
		'title'          => __( 'Event', 'staco-core' ),
		'plural_title'   => __( 'Events', 'staco-core' ),
		'menu_icon'      => 'dashicons-admin-post',
		'show_in_rest'   => true,
		'supports'       => array( 'title', 'thumbnail', 'editor', 'excerpt' ),
	),
	"{$prefix}_speaker"  => array(
		'title'          => __( 'Speaker', 'staco-core' ),
		'plural_title'   => __( 'Speakers', 'staco-core' ),
		'menu_icon'      => 'dashicons-admin-post',
		'show_in_rest'   => true,
		'supports'       => array( 'title', 'thumbnail', 'editor' ),
	),
	"{$prefix}_portfolio"  => array(
		'title'          => __( 'Portfolio', 'staco-core' ),
		'plural_title'   => __( 'Portfolios', 'staco-core' ),
		'menu_icon'      => 'dashicons-admin-post',
		'show_in_rest'   => true,
		'supports'       => array( 'title', 'thumbnail', 'editor', 'excerpt' ),
	),
);
$taxonomies = array(
	"{$prefix}_event_category" => array(
		'title'        => __( 'Event Category', 'staco-core' ),
		'plural_title' => __( 'Categories', 'staco-core' ),
		'post_types'   => "{$prefix}_event",
		'show_in_rest'   => true,
	),
	"{$prefix}_speaker_category" => array(
		'title'        => __( 'Speaker Category', 'staco-core' ),
		'plural_title' => __( 'Categories', 'staco-core' ),
		'post_types'   => "{$prefix}_speaker",
		'show_in_rest'   => true,
	),
	"{$prefix}_portfolio_category" => array(
		'title'        => __( 'Portfolio Category', 'staco-core' ),
		'plural_title' => __( 'Categories', 'staco-core' ),
		'post_types'   => "{$prefix}_portfolio",
		'show_in_rest'   => true,
	),
	"{$prefix}_portfolio_tag" => array(
		'title'        => __( 'Portfolio Tag', 'staco-core' ),
		'plural_title' => __( 'Tags', 'staco-core' ),
		'post_types'   => "{$prefix}_portfolio",
		'show_ui' => true,
        'query_var' => true,
        'show_in_rest' => true,
        'show_admin_column' => true,
        'hierarchical' => false,
	),
);

$Posts = staco_Posts::getInstance();
$Posts->add_post_types( $post_types );
$Posts->add_taxonomies( $taxonomies );