<?php
/*
Plugin Name: Staco Core
Plugin URI: https://besthemes.com/author/uigigs/
Description: Staco Core Plugin for Staco Theme
Version: 1.0.0
Author: UiGigs
Text Domain: staco-core
Domain Path: /languages
Author URI: https://besthemes.com/author/uigigs/
*/

if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! defined( 'Staco_Core' ) ) {
	$plugin_data = get_file_data( __FILE__, array( 'version' => 'Version' ) );
	define( 'Staco_Core',              $plugin_data['version'] );
	define( 'Staco_Core_SCRIPT_VER',   ( WP_DEBUG ) ? time() : Staco_Core );
	define( 'Staco_Core_THEME_PREFIX', 'staco' );
	define( 'Staco_Core_CPT', 		 'staco' );	
	define( 'Staco_Core_BASE_URL', plugin_dir_url( __FILE__ ) );
	define( 'Staco_Core_BASE_DIR', plugin_dir_path( __FILE__ ) );
}

class Staco_Core {

	public $plugin  = 'staco-core';
	public $action  = 'staco_theme_init';
	protected static $instance;

	public function __construct() {
		add_action( 'plugins_loaded',       array( $this, 'load_textdomain' ), 20 );
		add_action( 'plugins_loaded',       array( $this, 'demo_importer' ), 17 );
		add_action( 'after_setup_theme', array( $this, 'after_theme_loaded' ), 15 );
		add_action( 'rdtheme_social_share', array( $this, 'social_share' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'Staco_Core_enqueue_scripts' ), 20 );
		add_action( 'wp_enqueue_scripts', array( $this, 'Staco_Core_enqueue_scripts' ), 20 );
	}

	public static function instance() {
		if ( null == self::$instance ) {
			self::$instance = new self;
		}
		return self::$instance;
	}

	public function Staco_Core_enqueue_scripts() {
		wp_enqueue_style( 'staco-core', Staco_Core_BASE_URL . 'assets/css/staco-core.css' );
		wp_enqueue_script('staco-core', Staco_Core_BASE_URL . 'assets/js/staco-core.js', array( 'jquery' ), '', true );
	}
	
	public function after_theme_loaded() {
		if ( defined( 'staco_FRAMEWORK_VERSION' ) ) {
			require_once Staco_Core_BASE_DIR . 'inc/post-meta.php'; // Post Meta
			require_once Staco_Core_BASE_DIR . 'widgets/init.php'; // Widgets
		}
		if ( did_action( 'elementor/loaded' ) ) {
			require_once Staco_Core_BASE_DIR . 'elementor/init.php'; // Elementor
		}
	}

	public function social_share( $sharer ){
		include Staco_Core_BASE_DIR . 'inc/social-share.php';
	}

	public function load_textdomain() {
	    load_plugin_textdomain( $this->plugin, FALSE, basename( dirname( __FILE__ ) ) . '/languages' );
	}

	public function demo_importer() {
		require_once Staco_Core_BASE_DIR . 'inc/demo-importer.php';
		require_once Staco_Core_BASE_DIR . 'inc/demo-importer-ocdi.php';
	}

}
Staco_Core::instance();
